#include <Servo.h>


// pins for the sensor
const int trigPin = 9;
const int echoPin = 10;

// pins for red n green LEDS
const int greenLedPin = 11;
const int redLedPin = 12;

// pins for the servo
const int servoPin = 3;
// object servo 
Servo myServo;

// pins for the buzzer 
const int buzzerPin = 8; 
// distance for it to start 
const int distanceThreshold = 10;



void setup() {
 // defining the use lights
  pinMode(greenLedPin, OUTPUT);
  pinMode(redLedPin, OUTPUT);

// defining use of sensor 
  pinMode(trigPin, OUTPUT);
  pinMode(echoPin, INPUT);

// attaches it to a pin 
  myServo.attach(servoPin);

// serial monitor starter 
  Serial.begin(9600);

// starts with green light on red light off
  digitalWrite(greenLedPin, HIGH);
  digitalWrite(redLedPin, LOW);

 // degrees it starts on
  myServo.write(130);
}

void loop() {
// sending sound waves sensor 
  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);
// how long it takes for the sound to come back 
    long duration = pulseIn(echoPin, HIGH);
// calculates distance with the duration(^^)in cm 
  int distance = duration * 0.034 / 2;
 
// serial monitor 
  Serial.print("Distance: ");
  Serial.print(distance);
  Serial.println(" cm");
 // if distance is lower than 10 
  if (distance <= distanceThreshold) {
//delay of .5s in-between everything
    delay(500);
// servo 0 degrees & wait .5s 
    myServo.write(0);
    delay(500);
//green light off red light on      
    digitalWrite(redLedPin, HIGH);
    digitalWrite(greenLedPin, LOW);
// red light stays on for 5s    
    delay(5000);
// repeat 5 times
    for (int i = 0; i < 5; i++) {
// flicker / blink 
    digitalWrite(redLedPin, LOW);
    delay(500);
    digitalWrite(redLedPin, HIGH);
    delay(500);
    }
// buzzer goes off for 2s at 500hz
    tone(buzzerPin, 500); 
    delay(200);    
// to stop the buzzer 
    noTone(buzzerPin);     
// servo goes back to 130 degrees
    myServo.write(130);
// red light off green light on  
    digitalWrite(greenLedPin, HIGH);
    digitalWrite(redLedPin, LOW);
  }

// to make the code run smoother
  delay(100);
}
